/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.conndata;

import java.io.Serializable;

public class AccountInfo
implements Serializable {
    private static final long serialVersionUID = -26834407384669516L;
    private String account = "";
    private String userId = "";
    private String password = "";
    private String isoCountryCode = "";
    private String isoSubdivisionCode = "";

    public AccountInfo(String account, String userId, String pw) {
        this(account, userId, pw, "", "");
    }

    public AccountInfo(String account, String userId, String pw, String countryCode, String subdivCode) {
        if (account == null) {
            throw new IllegalArgumentException("Null account specified");
        }
        if (userId == null) {
            throw new IllegalArgumentException("Null user identifier specified");
        }
        if (pw == null) {
            throw new IllegalArgumentException("Null password specified");
        }
        if (countryCode == null) {
            throw new IllegalArgumentException("Null ISO country code specified");
        }
        if (!countryCode.equals("") && countryCode.length() != 2) {
            throw new IllegalArgumentException("Non 2 character ISO country code specified");
        }
        if (subdivCode == null) {
            throw new IllegalArgumentException("Null ISO subdivision code specified");
        }
        if (!subdivCode.equals("") && subdivCode.length() > 3) {
            throw new IllegalArgumentException("Non 1-3 character ISO country code specified");
        }
        this.account = account;
        this.userId = userId;
        this.password = pw;
        this.isoCountryCode = countryCode;
        this.isoSubdivisionCode = subdivCode;
    }

    public String getAccount() {
        return this.account;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getPassword() {
        return this.password;
    }

    public String getIsoCountryCode() {
        return this.isoCountryCode;
    }

    public String getIsoSubdivisionCode() {
        return this.isoSubdivisionCode;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[AccountInfo: account=" + this.account + ", ");
        sb.append("userId=" + this.userId + ", ");
        sb.append("password=" + this.password + ", ");
        sb.append("isoCtryCode=" + this.isoCountryCode + ", ");
        sb.append("isoSubdivCode=" + this.isoSubdivisionCode + "]");
        return sb.toString();
    }
}

